#include "scripts.h"
#include "SCUD.h"
//Script for Turret Spawns
void SCUD_Turret_Spawn::Created(GameObject * obj)
{
	Vector3 sp;
	GameObject *object;
	sp.X = 0;
	sp.Y = 0;
	sp.Z = 0;
	object = Commands->Create_Object(Get_Parameter("Turret_Preset"),sp);
	Commands->Attach_To_Object_Bone(object,obj,Get_Parameter("Bone_Name"));
	turID = Commands->Get_ID(object);
}
void SCUD_Turret_Spawn::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,4,&turID);
}
void SCUD_Turret_Spawn::Killed(GameObject * obj,GameObject * shooter)
{
	Vector3 tmb;
	tmb = Commands->Get_Bone_Position(obj,Get_Parameter("Bone_Name"));
	Commands->Create_Explosion(Get_Parameter("Explosion_Preset"),tmb,0);
}


//Script for the RefineryZone
void SCUD_Harvester_Zone::Entered(GameObject * obj,GameObject *enter)
{
	if ((enabled != false ) && (Get_Int_Parameter("Harvester_Preset_ID") == Commands->Get_Preset_ID(enter)))
	{
		enabled = false;
		Commands->Give_Money(enter,Get_Float_Parameter("Credits"),true);
		Commands->Start_Timer(obj,this,Get_Float_Parameter("Next_Harvester_Time"),1);
	}
	if ((enabled != false ) && (Get_Int_Parameter("LvlHarvester_Preset_ID") == Commands->Get_Preset_ID(enter)))
	{
		enabled = false;
		Commands->Give_Money(enter,Get_Float_Parameter("Credits"),true);
		Commands->Start_Timer(obj,this,Get_Float_Parameter("Next_Harvester_Time"),1);
	}
	if ((enabled != false ) && (Get_Int_Parameter("Thief_Preset_ID") == Commands->Get_Preset_ID(enter)))
	{
		enabled = false;
		Commands->Give_Money(enter,Get_Float_Parameter("Thief_Credits"),true);
		Commands->Start_Timer(obj,this,Get_Float_Parameter("Thief_Time"),1);
	}
}
void SCUD_Harvester_Zone::Timer_Expired(GameObject * obj,int number)
{
	enabled = true;
}
void SCUD_Harvester_Zone::Created(GameObject * obj)
{
	enabled = true;
}
void SCUD_Harvester_Zone::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,1,&enabled);
}



void SCUD_Custom_Follow_Waypath::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	int msg;
	int waypathid;
	float speed;
	waypathid = Get_Int_Parameter("WaypathID");
	speed = Get_Float_Parameter("Speed");
	msg = Get_Int_Parameter("Message");	
	if (msg == message)
	{
		ActionParamsStruct params;
		params.Set_Move_Arrive_Distance(100);
		params.Set_Basic(this,100,777,-1);
		params.Set_Goto(0,speed,10);
		params.Set_Goto_Waypath(waypathid,true,false,false);
		Commands->Action_Goto(obj,params);
	}
}

void SCUD_Custom_Follow_Waypath::Action_Complete(GameObject * obj,int action,ActionCompleteReason reason)
{
	int waypathid;
	float speed;
	waypathid = Get_Int_Parameter("WaypathID");
	speed = Get_Float_Parameter("Speed");
	ActionParamsStruct params;
	params.Set_Move_Arrive_Distance(100);
	params.Set_Basic(this,100,777,-1);
	params.Set_Goto(0,speed,10);
	params.Set_Goto_Waypath(waypathid,true,false,false);
	Commands->Action_Goto(obj,params);
}

void SCUD_Follow_Waypath_Until_Custom::Created(GameObject * obj)
{
	int waypathid;
	float speed;
	waypathid = Get_Int_Parameter("WaypathID");
	speed = Get_Float_Parameter("Speed");
	ActionParamsStruct params;
	params.Set_Move_Arrive_Distance(100);
	params.Set_Basic(this,100,777,-1);
	params.Set_Goto(0,speed,10);
	params.Set_Goto_Waypath(waypathid,true,false,false);
	Commands->Action_Goto(obj,params);
	disable = false;
}
void SCUD_Follow_Waypath_Until_Custom::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	int msg;
	msg = Get_Int_Parameter("Message");	
	if (msg == message)
	{
		disable = true;
	}
}
void SCUD_Follow_Waypath_Until_Custom::Action_Complete(GameObject * obj,int action,ActionCompleteReason reason)
{
	if (disable == false)
	{
		int waypathid;
		float speed;
		waypathid = Get_Int_Parameter("WaypathID");
		speed = Get_Float_Parameter("Speed");
		ActionParamsStruct params;
		params.Set_Move_Arrive_Distance(100);
		params.Set_Basic(this,100,777,-1);
		params.Set_Goto(0,speed,10);
		params.Set_Goto_Waypath(waypathid,true,false,false);
		Commands->Action_Goto(obj,params);
	}
}
void SCUD_Follow_Waypath_Until_Custom::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,1,&disable);
}


//Script for Single Preset Buy Terminals (dont work in MP)
void SCUD_Poke_Preset_Buy::Created(GameObject * obj)
{
	active = 1;
	Commands->Enable_HUD_Pokable_Indicator(obj,1);
}
void SCUD_Poke_Preset_Buy::Custom(GameObject * obj,GameObject * sender)
{
	active = 1;
	Commands->Enable_HUD_Pokable_Indicator(obj,1);
}
void SCUD_Poke_Preset_Buy::Poked(GameObject * obj,GameObject * poker)
{
	//dec
	const char *preset;
	int x;
	int cost;
	Vector3 spawn_position;
	//def
	x = Get_Int_Parameter("Player_Type");
	if (CheckPlayerType(poker,x) != 0)
	{
		return;
	}
	preset = Get_Parameter("Preset_Name");
	cost = Get_Int_Parameter("Cost");
	//func
	if (cost <= Commands->Get_Money(poker))
	{
		cost = -cost;
		spawn_position = Get_Vector3_Parameter("location");
		Commands->Give_Money(poker,(float)cost,0);
		Commands->Create_Object(preset, spawn_position);
	}
}
void SCUD_Poke_Preset_Buy::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,1,&active);
}


//Script for Single Preset Buy Terminals (Vehicle way)
void SCUD_Preset_Buy::Created(GameObject * obj)
{
	active = 1;
	Commands->Enable_HUD_Pokable_Indicator(obj,1);
}
void SCUD_Preset_Buy::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	//dec
	const char *preset;
	GameObject * npre;
	int x;
	int cost;
	float facing;
	Vector3 spawn_position;
	//def
	x = Get_Int_Parameter("Player_Type");
	if (CheckPlayerType(sender,x) != 0)
	{
		return;
	}
	cost = Get_Int_Parameter("Cost");
	//func
	if (message == CUSTOM_EVENT_VEHICLE_ENTER)
	{
		if (cost <= Commands->Get_Money(sender))
		{
			cost = -cost;
			preset = Get_Parameter("Preset_Name");
			spawn_position = Get_Vector3_Parameter("location");
			Commands->Give_Money(sender,(float)cost,0);
			npre = Commands->Create_Object(preset,spawn_position);
			facing = Get_Float_Parameter("Rotation");
			Commands->Set_Facing(npre,facing);
		}
	}
}
void SCUD_Preset_Buy::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,1,&active);
}

//Script for Vehicle Purchase on exit Terminal and Custom send on enter
void SCUD_CustomSend_Preset_Buy::Created(GameObject * obj)
{
	active = 1;
	Commands->Enable_HUD_Pokable_Indicator(obj,1);
}
void SCUD_CustomSend_Preset_Buy::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	//dec
	const char *preset;
	GameObject * npre;
	int x;
	int cost;
	float facing;
	Vector3 spawn_position;
	//def
	x = Get_Int_Parameter("Player_Type");
	if (CheckPlayerType(sender,x) != 0)
	{
		return;
	}
	cost = Get_Int_Parameter("Cost");
	//func
	if (message == CUSTOM_EVENT_VEHICLE_ENTER)
	{
		Commands->Send_Custom_Event(obj,Commands->Find_Object(Get_Int_Parameter("SendID")),Get_Int_Parameter("SendMessage"),Get_Int_Parameter("SendParam"),0);
	}
	if (message == CUSTOM_EVENT_VEHICLE_EXIT)
	{
		if (cost <= Commands->Get_Money(sender))
		{
			cost = -cost;
			preset = Get_Parameter("Preset_Name");
			spawn_position = Get_Vector3_Parameter("location");
			Commands->Give_Money(sender,(float)cost,0);
			npre = Commands->Create_Object(preset,spawn_position);
			facing = Get_Float_Parameter("Rotation");
			Commands->Set_Facing(npre,facing);
		}
	}
}
void SCUD_CustomSend_Preset_Buy::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,1,&active);
}


//Vehicle Purchase Script with Waypath function
void SCUD_CustomSend_PresetBuy_FollowWaypath::Created(GameObject * obj)
{
	active = 1;
	Commands->Enable_HUD_Pokable_Indicator(obj,1);
}
void SCUD_CustomSend_PresetBuy_FollowWaypath::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	//dec
	const char *preset;
	GameObject * npre;
	int x;
	int cost;
	float facing;
	Vector3 spawn_position;
	//def
	x = Get_Int_Parameter("Player_Type");
	if (CheckPlayerType(sender,x) != 0)
	{
		return;
	}
	cost = Get_Int_Parameter("Cost");
	//func
	if (message == CUSTOM_EVENT_VEHICLE_ENTER)
	{
		Commands->Send_Custom_Event(obj,Commands->Find_Object(Get_Int_Parameter("SendID")),Get_Int_Parameter("SendMessage"),Get_Int_Parameter("SendParam"),0);
	}
	if (message == CUSTOM_EVENT_VEHICLE_EXIT)
	{
		if (cost <= Commands->Get_Money(sender))
		{
			cost = -cost;
			preset = Get_Parameter("Preset_Name");
			spawn_position = Get_Vector3_Parameter("location");
			Commands->Give_Money(sender,(float)cost,0);
			npre = Commands->Create_Object(preset,spawn_position);
			facing = Get_Float_Parameter("Rotation");
			Commands->Set_Facing(npre,facing);
			if (Get_Int_Parameter("Waypath_enabled") == 1)
			{
				int waypathid;
				float speed;
				waypathid = Get_Int_Parameter("WaypathID");
				speed = Get_Float_Parameter("Speed");
				ActionParamsStruct params;
				params.Set_Move_Arrive_Distance(100);
				params.Set_Basic(this,100,777,-1);
				params.Set_Goto(0,speed,10);
				params.Set_Goto_Waypath(waypathid,true,false,false);
				Commands->Action_Goto(npre,params);
			}
		}
	}
}
void SCUD_CustomSend_PresetBuy_FollowWaypath::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,1,&active);
}


//Vehicle Purchase Script with Waypath function
void SCUD_CustomSend_PresetBuy_GeneralPresets_FollowWaypath::Created(GameObject * obj)
{
	active = 1;
	Commands->Enable_HUD_Pokable_Indicator(obj,1);
}
void SCUD_CustomSend_PresetBuy_GeneralPresets_FollowWaypath::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	//dec
	const char *preset;
	const char *preset1;
	const char *preset2;
	const char *preset3;
	GameObject * npre;
	GameObject * npre1;
	GameObject * npre2;
	GameObject * npre3;
	int x;
	int cost;
	int cost1;
	int cost2;
	int cost3;
	float facing;
	Vector3 spawn_position;
	int senderid;
	int generalid1;
	int generalid2;
	int generalid3;
	//def
	senderid = Commands->Get_Preset_ID(sender);
	generalid1 = Get_Int_Parameter("General1_Preset_ID");
	generalid2 = Get_Int_Parameter("General2_Preset_ID");
	generalid3 = Get_Int_Parameter("General3_Preset_ID");
	x = Get_Int_Parameter("Player_Type");
	if (CheckPlayerType(sender,x) != 0)
	{
		return;
	}
	cost = Get_Int_Parameter("Cost");
	cost1 = Get_Int_Parameter("General1_Preset_Cost");
	cost2 = Get_Int_Parameter("General2_Preset_Cost");
	cost3 = Get_Int_Parameter("General3_Preset_Cost");
	//func
	if (message == CUSTOM_EVENT_VEHICLE_ENTER)
	{
		Commands->Send_Custom_Event(obj,Commands->Find_Object(Get_Int_Parameter("SendID")),Get_Int_Parameter("SendMessage"),Get_Int_Parameter("SendParam"),0);
	}
	if (message == CUSTOM_EVENT_VEHICLE_EXIT)
	{
		if ((senderid != generalid1) && (senderid != generalid2) && (senderid != generalid3))
		{
			if (cost <= Commands->Get_Money(sender))
			{
				cost = -cost;
				preset = Get_Parameter("Preset_Name");
				spawn_position = Get_Vector3_Parameter("location");
				Commands->Give_Money(sender,(float)cost,0);
				npre = Commands->Create_Object(preset,spawn_position);
				facing = Get_Float_Parameter("Rotation");
				Commands->Set_Facing(npre,facing);
				if (Get_Int_Parameter("Waypath_enabled") == 1)
				{
					int waypathid;
					float speed;
					waypathid = Get_Int_Parameter("WaypathID");
					speed = Get_Float_Parameter("Speed");
					ActionParamsStruct params;
					params.Set_Move_Arrive_Distance(100);
					params.Set_Basic(this,100,777,-1);
					params.Set_Goto(0,speed,10);
					params.Set_Goto_Waypath(waypathid,true,false,false);
					Commands->Action_Goto(npre,params);
				}
			}
		}
		if (senderid == generalid1)
		{
			if (cost1 <= Commands->Get_Money(sender))
			{
				cost1 = -cost1;
				preset1 = Get_Parameter("General1_Preset_Name");
				spawn_position = Get_Vector3_Parameter("location");
				Commands->Give_Money(sender,(float)cost1,0);
				npre1 = Commands->Create_Object(preset1,spawn_position);
				facing = Get_Float_Parameter("Rotation");
				Commands->Set_Facing(npre1,facing);
				if (Get_Int_Parameter("Waypath_enabled") == 1)
				{
					int waypathid;
					float speed;
					waypathid = Get_Int_Parameter("WaypathID");
					speed = Get_Float_Parameter("Speed");
					ActionParamsStruct params;
					params.Set_Move_Arrive_Distance(100);
					params.Set_Basic(this,100,777,-1);
					params.Set_Goto(0,speed,10);
					params.Set_Goto_Waypath(waypathid,true,false,false);
					Commands->Action_Goto(npre1,params);
				}
			}
		}
		if (senderid == generalid2)
		{
			if (cost2 <= Commands->Get_Money(sender))
			{
				cost2 = -cost2;
				preset2 = Get_Parameter("General2_Preset_Name");
				spawn_position = Get_Vector3_Parameter("location");
				Commands->Give_Money(sender,(float)cost2,0);
				npre2 = Commands->Create_Object(preset2,spawn_position);
				facing = Get_Float_Parameter("Rotation");
				Commands->Set_Facing(npre2,facing);
				if (Get_Int_Parameter("Waypath_enabled") == 1)
				{
					int waypathid;
					float speed;
					waypathid = Get_Int_Parameter("WaypathID");
					speed = Get_Float_Parameter("Speed");
					ActionParamsStruct params;
					params.Set_Move_Arrive_Distance(100);
					params.Set_Basic(this,100,777,-1);
					params.Set_Goto(0,speed,10);
					params.Set_Goto_Waypath(waypathid,true,false,false);
					Commands->Action_Goto(npre2,params);
				}
			}
		}
		if (senderid == generalid3)
		{
			if (cost3 <= Commands->Get_Money(sender))
			{
				cost3 = -cost3;
				preset3 = Get_Parameter("General3_Preset_Name");
				spawn_position = Get_Vector3_Parameter("location");
				Commands->Give_Money(sender,(float)cost3,0);
				npre3 = Commands->Create_Object(preset3,spawn_position);
				facing = Get_Float_Parameter("Rotation");
				Commands->Set_Facing(npre3,facing);
				if (Get_Int_Parameter("Waypath_enabled") == 1)
				{
					int waypathid;
					float speed;
					waypathid = Get_Int_Parameter("WaypathID");
					speed = Get_Float_Parameter("Speed");
					ActionParamsStruct params;
					params.Set_Move_Arrive_Distance(100);
					params.Set_Basic(this,100,777,-1);
					params.Set_Goto(0,speed,10);
					params.Set_Goto_Waypath(waypathid,true,false,false);
					Commands->Action_Goto(npre3,params);
				}
			}
		}

	}
}
void SCUD_CustomSend_PresetBuy_GeneralPresets_FollowWaypath::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,1,&active);
}



/* dont work yet!
//Script for Single Preset Buy Terminals + Destroy Object (Vehicle way)
void SCUD_Preset_Buy_Destroy_Object::Created(GameObject * obj)
{
	active = 1;
	Commands->Enable_HUD_Pokable_Indicator(obj,1);
}

void SCUD_Preset_Buy_Destroy_Object::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	//dec
	const char *c;
	int unknown;
	Vector3 v;
	const char *preset;
	GameObject * npre; 
	int x;
	int cost;
	float facing;
	Vector3 spawn_position;
	//def
	x = Get_Int_Parameter("Player_Type");
	GameObject * sendobj;
	if (CheckPlayerType(sender,x) != 0)
	{
		return;
	}
	cost = Get_Int_Parameter("Cost");
	//func
	if (message == CUSTOM_EVENT_VEHICLE_ENTER)
	{
		if (cost <= Commands->Get_Money(sender))
		{
			cost = -cost;
			preset = Get_Parameter("Preset_Name");
			spawn_position = Get_Vector3_Parameter("location");
			Commands->Give_Money(sender,(float)cost,0);
			npre = Commands->Create_Object(preset,spawn_position);
			facing = Get_Float_Parameter("Rotation");
			Commands->Set_Facing(npre,facing);
		}
	
	}
	c = Get_Parameter("Explosion");
	v = Commands->Get_Position(obj);
	Commands->Create_Explosion(c,v,0);
	//Commands->Destroy_Object(obj);


}
void SCUD_Preset_Buy_Destroy_Object::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,1,&active);
}


*/

/*dont work yet!
//Script for Single Preset Buy Terminals + Send Custom(Vehicle way)
void SCUD_Preset_Buy_Send_Custom::Created(GameObject * obj)
{
	active = 1;
	Commands->Enable_HUD_Pokable_Indicator(obj,1);
}

void SCUD_Preset_Buy_Send_Custom::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	//dec
	const char *c;
	int unknown;
	Vector3 v;
	const char *preset;
	GameObject * npre;
	int x;
	int cost;
	float facing;
	Vector3 spawn_position;
	//def
	x = Get_Int_Parameter("Player_Type");
	GameObject * sendobj;
	if (CheckPlayerType(sender,x) != 0)
	{
		return;
	}
	cost = Get_Int_Parameter("Cost");
	//func
	if (message == CUSTOM_EVENT_VEHICLE_ENTER)
	{
		if (cost <= Commands->Get_Money(sender))
		{
			cost = -cost;
			preset = Get_Parameter("Preset_Name");
			spawn_position = Get_Vector3_Parameter("location");
			Commands->Give_Money(sender,(float)cost,0);
			npre = Commands->Create_Object(preset,spawn_position);
			facing = Get_Float_Parameter("Rotation");
			Commands->Set_Facing(npre,facing);
		}
		Commands->Send_Custom_Event(obj,Commands->Find_Object(Get_Int_Parameter("SendID")),Get_Int_Parameter("SendMessage"),Get_Int_Parameter("SendParam"),0);
	}
	
	


}
void SCUD_Preset_Buy_Send_Custom::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,1,&active);
}
*/
//Script for Deployable Vehicle
void SCUD_Deployable_Vehicle::Created(GameObject * obj)
{
	pilotID = 0;
}
void SCUD_Deployable_Vehicle::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	if(message == CUSTOM_EVENT_VEHICLE_ENTER)
	{
		if(pilotID == 0)
		{
			pilotID = Commands->Get_ID(sender);
		}
	}
	if(message == CUSTOM_EVENT_VEHICLE_EXIT)
	{
		if(pilotID == Commands->Get_ID(sender))
		{
			pilotID = 0;
		}
	}
}
void SCUD_Deployable_Vehicle::Damaged(GameObject * obj,GameObject * damager,float damage)
{
	const char* preset;
	GameObject * npre;
	Vector3 pos;
	float health;
	float facing;
	if ((damager == Commands->Find_Object(pilotID)) && (damager != NULL))
	{
		preset = Get_Parameter("Animated_Preset");
		pos = Commands->Get_Position(obj);
		health = Commands->Get_Health(obj);
		npre = Commands->Create_Object(preset,pos);
		Commands->Set_Health(npre,health);
		health = Commands->Get_Shield_Strength(obj);
		Commands->Set_Shield_Strength(npre,health);
		facing = Commands->Get_Facing(obj);
		Commands->Set_Facing(npre,facing);
 		preset = Get_Parameter("Explosion_Preset");
		Commands->Create_Explosion(preset,pos,0);
	}
}
void SCUD_Deployable_Vehicle::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,4,&pilotID);
}

//Script for Deployable Vehicle Animation
void SCUD_Deploy_Animation::Created(GameObject * obj)
{
	Commands->Start_Timer(obj, this,Get_Float_Parameter("Time_Till_Death") , 1);
}
void SCUD_Deploy_Animation::Timer_Expired(GameObject * obj,int number)
{
	const char* preset;
	GameObject * npre;
	Vector3 pos;
	float health;
	float facing;
	preset = Get_Parameter("Deployed_Tank_Preset");
	pos = Commands->Get_Position(obj);
	health = Commands->Get_Health(obj);
	npre = Commands->Create_Object(preset,pos);
	Commands->Set_Health(npre,health);
	health = Commands->Get_Shield_Strength(obj);
	Commands->Set_Shield_Strength(npre,health);
	facing = Commands->Get_Facing(obj);
	Commands->Set_Facing(npre,facing);
 	preset = Get_Parameter("Explosion_Preset");
	Commands->Create_Explosion(preset,pos,0);
}







/* not yet possible
void SCUD_Generals_VehicleAbility::Created(GameObject * obj)
{
	active = 1;
	Commands->Enable_HUD_Pokable_Indicator(obj,1);
}
void SCUD_Generals_VehicleAbility::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	//dec
	float health;
	float shield;
	float healthup;
	float shieldup;
	int GeneralID;
	//def
	healthup = Get_Float_Parameter("Health_Up_4_General");
	shieldup = Get_Float_Parameter("Shield_Up_4_General");
	GeneralID = Get_Int_Parameter("General_Preset_ID");
	//func
	if (message == CUSTOM_EVENT_VEHICLE_ENTER)
	{
		if (GeneralID == Commands->Get_Preset_ID(sender))
		{
			health = Commands->Get_Max_Health(obj);
			Commands->Set_Health(obj,health + healthup); 
			shield = Commands->Get_Max_Shield_Strength(obj);
			Commands->Set_Shield_Strength(obj,shield + shieldup);
		}
	}
	if (message == CUSTOM_EVENT_VEHICLE_EXIT)
	{
		if (GeneralID == Commands->Get_Preset_ID(sender))
		{
			Commands->Set_Health(obj,Commands->Get_Max_Health(obj));
			Commands->Set_Shield_Strength(obj,Commands->Get_Max_Shield_Strength(obj));
		}
	}
}
*/


//Script for the DeathZone(dont work yet)
void SCUD_DeathZoneOnCustom::Entered(GameObject * obj,GameObject * enter)
{
	Auto_Save_Variable(1,10,&visitor);
	visitor = Commands->Get_ID(enter);
}
void SCUD_DeathZoneOnCustom::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	int msg;
	const char *exp;
	msg = Get_Int_Parameter("Message");
	exp = Get_Parameter("Explosion");
	if (message == msg)
	{
		Commands->Create_Explosion(exp,Commands->Get_Position(Commands->Find_Object(visitor)),0);
	}
}
void SCUD_DeathZoneOnCustom::Exited(GameObject * obj,GameObject * exit)
{
	visitor = 0;
}


//Harvester Controller Script
void SCUD_Harvester_Control::Created(GameObject * obj)
{
	USHarvLim = 0;
	CHHarvLim = 0;
	uslimreacht = 0;
	chlimreacht = 0;
}
void SCUD_Harvester_Control::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,4,&USHarvLim);
	Auto_Save_Variable(1,4,&CHHarvLim);
	Auto_Save_Variable(1,4,&uslimreacht);
	Auto_Save_Variable(1,4,&chlimreacht);
}
void SCUD_Harvester_Control::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	GameObject * send;
	int msg;
	int sparam;
	int usterminal;
	int chterminal;
	int uslimit;
	int chlimit;
	int uscashmsg;
	int chcashmsg;
	usterminal = Get_Int_Parameter("US_Harvester_Terminal_ID");
	chterminal = Get_Int_Parameter("CH_Harvester_Terminal_ID");
	uslimit = Get_Int_Parameter("USA_Harvester_Limit");
	chlimit = Get_Int_Parameter("China_Harvester_Limit");
	uscashmsg = Get_Int_Parameter("USA_Harvester_Cost");
	chcashmsg = Get_Int_Parameter ("China_Harvester_Cost");
	msg = 3054;
	sparam = 0;
	send = sender;
	if (uslimreacht == 1)
	{
		if (message == 1919)
		{
			Commands->Give_Money(Commands->Find_Object(param),(float)uscashmsg,0);
		}
	}
	if (chlimreacht == 1)
	{
		if (message == 1920)
		{
			Commands->Give_Money(Commands->Find_Object(param),(float)chcashmsg,0);
		}
	}
	if (USHarvLim < uslimit)
	{
		uslimreacht = 0;
	}
	if (CHHarvLim < chlimit)
	{
		chlimreacht = 0;
	}
	if (USHarvLim >= uslimit)
	{
		uslimreacht = 1;
	}
	if (CHHarvLim >= chlimit)
	{
		chlimreacht = 1;
	}
	if (message == 1015)
	{
		USHarvLim++;
		if (USHarvLim >= uslimit)
		{
			Commands->Send_Custom_Event(obj,sender,msg,sparam,0);
		}
	}
	if (message == 1016)
	{
		USHarvLim--;
		if (USHarvLim < uslimit)
		{
		}
	}
	
	if (message == 1025)
	{
		CHHarvLim++;
		if (CHHarvLim >= chlimit)
			Commands->Send_Custom_Event(obj,sender,msg,sparam,0);
		}
	if (message == 1026)
	{
		CHHarvLim--;
		if (CHHarvLim < chlimit)
		{
		}
	}
}


//Script for the USA Harvester
void SCUD_USHarvester::Created(GameObject * obj)
{
	GameObject * send;
	int msg;
	int sparam;
	HarvCtrlID = Get_Int_Parameter("Harvester_Control_ID");
	msg = 1015;
	sparam = 0;
	send = Commands->Find_Object(HarvCtrlID);
	Commands->Send_Custom_Event(obj,send,msg,sparam,0);
}
void SCUD_USHarvester::Killed(GameObject * obj,GameObject * shooter)
{
	GameObject * send;
	int msg;
	int sparam;
	msg = 1016;
	sparam = 0;
	send = Commands->Find_Object(HarvCtrlID);
	Commands->Send_Custom_Event(obj,send,msg,sparam,0);
}
void SCUD_USHarvester::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	Vector3 v;
	v = Commands->Get_Position(obj);
	if (message == 3054)
	{
		Commands->Create_Explosion(Get_Parameter("Explosion_Preset_Name"),v,0);
	}
}


//Script for the China Harvester
void SCUD_CHHarvester::Created(GameObject * obj)
{
	GameObject * send;
	int msg;
	int sparam;
	HarvCtrlID = Get_Int_Parameter("Harvester_Control_ID");
	msg = 1025;
	sparam = 0;
	send = Commands->Find_Object(HarvCtrlID);
	Commands->Send_Custom_Event(obj,send,msg,sparam,0);
}
void SCUD_CHHarvester::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	Vector3 v;
	v = Commands->Get_Position(obj);
	if (message == 3054)
	{
		Commands->Create_Explosion(Get_Parameter("Explosion_Preset_Name"),v,0);
	}
}
void SCUD_CHHarvester::Killed(GameObject * obj,GameObject * shooter)
{
	GameObject * send;
	int msg;
	int sparam;
	msg = 1026;
	sparam = 0;
	send = Commands->Find_Object(HarvCtrlID);
	Commands->Send_Custom_Event(obj,send,msg,sparam,0);
}


//Script for the USA Harvester Terminal
void SCUD_USHarvester_Terminal::Created(GameObject * obj)
{
	active = 1;
	Commands->Enable_HUD_Pokable_Indicator(obj,1);
	visitorID = 0;
	
}
void SCUD_USHarvester_Terminal::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	const char *preset;
	GameObject * npre;
	int x;
	int cost;
	float facing;
	Vector3 spawn_position;
	x = Get_Int_Parameter("Player_Type");
	if (CheckPlayerType(sender,x) != 0)
	{
		return;
	}
	cost = Get_Int_Parameter("Cost");
	if (message == CUSTOM_EVENT_VEHICLE_ENTER)
	{
		Commands->Send_Custom_Event(obj,Commands->Find_Object(Get_Int_Parameter("SendID")),Get_Int_Parameter("SendMessage"),Get_Int_Parameter("SendParam"),0);
		visitorID = Commands->Get_ID(sender);
	}
	if (message == CUSTOM_EVENT_VEHICLE_EXIT)
	{
		if (cost <= Commands->Get_Money(sender))
		{
			cost = -cost;
			preset = Get_Parameter("Preset_Name");
			spawn_position = Get_Vector3_Parameter("location");
			Commands->Give_Money(sender,(float)cost,0);
			npre = Commands->Create_Object(preset,spawn_position);
			facing = Get_Float_Parameter("Rotation");
			Commands->Set_Facing(npre,facing);
			Commands->Send_Custom_Event(obj,Commands->Find_Object(Get_Int_Parameter("Harvester_Control_ID")),1919,visitorID,0);
			if (Get_Int_Parameter("Waypath_enabled") == 1)
			{
				int waypathid;
				float speed;
				waypathid = Get_Int_Parameter("WaypathID");
				speed = Get_Float_Parameter("Speed");
				ActionParamsStruct params;
				params.Set_Move_Arrive_Distance(100);
				params.Set_Basic(this,100,777,-1);
				params.Set_Goto(0,speed,10);
				params.Set_Goto_Waypath(waypathid,true,false,false);
				Commands->Action_Goto(npre,params);
			}
		}
	}
}
void SCUD_USHarvester_Terminal::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,1,&active);
}


//Script for the China Harvester Terminal
void SCUD_CHHarvester_Terminal::Created(GameObject * obj)
{
	active = 1;
	Commands->Enable_HUD_Pokable_Indicator(obj,1);
	visitorID = 0;
}
void SCUD_CHHarvester_Terminal::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	const char *preset;
	GameObject * npre;
	int x;
	int cost;
	float facing;
	Vector3 spawn_position;
	x = Get_Int_Parameter("Player_Type");
	if (CheckPlayerType(sender,x) != 0)
	{
		return;
	}
	cost = Get_Int_Parameter("Cost");
	if (message == CUSTOM_EVENT_VEHICLE_ENTER)
	{
		Commands->Send_Custom_Event(obj,Commands->Find_Object(Get_Int_Parameter("SendID")),Get_Int_Parameter("SendMessage"),Get_Int_Parameter("SendParam"),0);
		visitorID = Commands->Get_ID(sender);
	}
	if (message == CUSTOM_EVENT_VEHICLE_EXIT)
	{
		if (cost <= Commands->Get_Money(sender))
		{
			cost = -cost;
			preset = Get_Parameter("Preset_Name");
			spawn_position = Get_Vector3_Parameter("location");
			Commands->Give_Money(sender,(float)cost,0);
			npre = Commands->Create_Object(preset,spawn_position);
			facing = Get_Float_Parameter("Rotation");
			Commands->Set_Facing(npre,facing);
			Commands->Send_Custom_Event(obj,Commands->Find_Object(Get_Int_Parameter("Harvester_Control_ID")),1920,visitorID,0);
			if (Get_Int_Parameter("Waypath_enabled") == 1)
			{
				int waypathid;
				float speed;
				waypathid = Get_Int_Parameter("WaypathID");
				speed = Get_Float_Parameter("Speed");
				ActionParamsStruct params;
				params.Set_Move_Arrive_Distance(100);
				params.Set_Basic(this,100,777,-1);
				params.Set_Goto(0,speed,10);
				params.Set_Goto_Waypath(waypathid,true,false,false);
				Commands->Action_Goto(npre,params);
			}
		}
	}
}
void SCUD_CHHarvester_Terminal::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,1,&active);
}

//Script for the Particle Cannon
void SCUD_SuperWeapon::Created(GameObject * obj)
{
	counter=0;
}
void SCUD_SuperWeapon::Damaged(GameObject * obj,GameObject * damager,float damage)
{
	counter++;
	if (counter == Get_Int_Parameter("SuperWeaponAmmo"))
	{
		Commands->Send_Custom_Event(obj,obj,5432,0,Get_Float_Parameter("FireTimeSinceFirstShot"));
	}
}
void SCUD_SuperWeapon::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	if (message == 5432)
	{
		Commands->Destroy_Object(obj);
	}
}



/*
void SCUD_CTO_Controler::Created(GameObject * obj)
{
	oil1 = 0;
	//oil2 = 0;
	//oil3 = 0;
	//oil4 = 0;
	//oil5 = 0;
	//oil6 = 0;
}
void SCUD_CTO_Controler::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	if (message == 4511)
	{
		oil1 = 1;
	}
}

void SCUD_CTO_Zone::Created(GameObject * obj)
{
	const char * uslogo;
	const char * chlogo;
	logoloc = Get_Vector3_Parameter("Logo_Location");
}
void SCUD_CTO_Zone::Entered(GameObject * obj, GameObject * enter)
{
	if (Get_Int_Parameter("US_Flag_Preset_ID") == Commands->Get_Preset_ID(enter))
	{
		Commands->Send_Custom_Event(obj,Commands->Find_Object(Get_Int_Parameter("CTO_Controler_ID")),4511,0,0);
		Commands->Destroy_Object(chlogo);
		Commands->Create_Object(uslogo = Get_Parameter("USLogo_Preset_Name"),logoloc);
	}
	if (Get_Int_Parameter("CH_Flag_Preset_ID") == Commands->Get_Preset_ID(enter))
	{
		Commands->Send_Custom_Event(obj,Commands->Find_Object(Get_Int_Parameter("CTO_Controler_ID")),4510,0,0);
		Commands->Destroy_Object(uslogo);
		Commands->Create_Object(chlogo = Get_Parameter("CHLogo_Preset_Name"),logoloc);
	}
}
*/
void SCUD_Set_Player_Type_OnCustom::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	int msg;
	int type;
	type = Get_Int_Parameter("Player_Type");
	if (type == 2)
	{
		type = Commands->Get_Player_Type(sender);
	}
	msg = Get_Int_Parameter("Message");
	if (message == msg)
	{
		Commands->Set_Player_Type(obj,type);
	}
}

void SCUD_DozerBuildTurret::Custom(GameObject * obj, int message, int param, GameObject * sender)
{
	if(message == CUSTOM_EVENT_VEHICLE_ENTER)
	{
		if(PilotID == 0)
		{
			PilotID = Commands->Get_ID(sender);
		}
	}
	if(message == CUSTOM_EVENT_VEHICLE_EXIT)
	{
		if(PilotID == Commands->Get_ID(sender))
		{
			PilotID = 0;
		}
	}
}
void SCUD_DozerBuildTurret::Damaged(GameObject * obj,GameObject * damager,float damage)
{
	//dec
	const char *preset;
	GameObject * npre;
	int cost;
	float facing;
	Vector3 spawn_position;
	//def

	
	cost = Get_Int_Parameter("Cost");
	//func
	if ((damager == Commands->Find_Object(PilotID)) && (damager != NULL))
	{
		if (cost <= Commands->Get_Money(damager))
		{
			cost = -cost;
			preset = Get_Parameter("Turret_PresetName");
			spawn_position = Commands->Get_Position(damager);
			spawn_position.Z = spawn_position.Z - 2;
			Commands->Give_Money(damager,(float)cost,0);
			Commands->Send_Custom_Event(obj,Commands->Find_Object(Get_Int_Parameter("Controller_ID")),1920,PilotID,0);
			npre = Commands->Create_Object(preset,spawn_position);
			facing = Commands->Get_Facing(damager);
			Commands->Set_Facing(npre,facing);
		}
	}
}

void SCUD_TurretBuildup::Created(GameObject * obj)
{
	int msg;
	int param;
	
	msg = 1010;
	param = 0;
	Commands->Send_Custom_Event(obj,obj,msg,param,Get_Float_Parameter("Buildup_Time"));
}
void SCUD_TurretBuildup::Custom(GameObject * obj, int message, int param, GameObject * sender)
{
	GameObject * turret;
	const char *preset;
	if (message == 1010)
	{
		preset = Get_Parameter("Turret_PresetName");
		turret = Commands->Create_Object(preset,Commands->Get_Position(obj));
		Commands->Set_Facing(turret,Commands->Get_Facing(obj));
		Commands->Destroy_Object(obj);
	}
}
ScriptRegistrant<SCUD_Turret_Spawn> SCUD_Turret_Spawn_Registrant ("SCUD_Turret_Spawn","Turret_Preset:string,Bone_Name=BoneName:string,Explosion_Preset:string");
ScriptRegistrant<SCUD_Harvester_Zone> SCUD_Harvester_Zone_Registrant("SCUD_Harvester_Zone","Credits=1000.00:float,Next_Harvester_Time=5.00:float,Harvester_Preset_ID:int,LvlHarvester_Preset_ID:int,Thief_Credits=500.00:float,Thief_Time=5.00:float,Thief_Preset_ID:int");
ScriptRegistrant<SCUD_Custom_Follow_Waypath> SCUD_Custom_Follow_Waypath_Registrant("SCUD_Custom_Follow_Waypath","WaypathID:int,Speed:float,Message:int");
ScriptRegistrant<SCUD_Follow_Waypath_Until_Custom> SCUD_Follow_Waypath_Until_Custom_Registrant("SCUD_Follow_Waypath_Until_Custom","WaypathID:int,Speed:float,Message:int");
ScriptRegistrant<SCUD_Poke_Preset_Buy> SCUD_Poke_Preset_Buy_Registrant("SCUD_Poke_Preset_Buy","Unknown:float,Preset_Name:string,Cost:int,location:Vector3,Player_Type:int");
ScriptRegistrant<SCUD_Preset_Buy> SCUD_Preset_Buy_Registrant("SCUD_Preset_Buy","Unknown:float,Preset_Name:string,Cost:int,location:Vector3,Player_Type:int,Rotation:float");
ScriptRegistrant<SCUD_CustomSend_Preset_Buy> SCUD_CustomSend_Preset_Buy_Registrant("SCUD_CustomSend_Preset_Buy","Unknown:float,SendID:int,SendMessage:int,SendParam:int,Preset_Name:string,Cost:int,location:Vector3,Player_Type:int,Rotation:float");
ScriptRegistrant<SCUD_CustomSend_PresetBuy_FollowWaypath> SCUD_CustomSend_PresetBuy_FollowWaypath_Registrant("SCUD_CustomSend_PresetBuy_FollowWaypath","Unknown:float,SendID:int,SendMessage:int,SendParam:int,Preset_Name:string,Cost:int,location:Vector3,Player_Type:int,Rotation:float,Waypath_enabled:int,WaypathID:int,Speed:float");
ScriptRegistrant<SCUD_CustomSend_PresetBuy_GeneralPresets_FollowWaypath> SCUD_CustomSend_PresetBuy_GeneralPresets_FollowWaypath_Registrant("SCUD_CustomSend_PresetBuy_GeneralPresets_FollowWaypath","Unknown:float,SendID:int,SendMessage:int,SendParam:int,Preset_Name:string,Cost:int,location:Vector3,Player_Type:int,Rotation:float,General1_Preset_ID:int,General2_Preset_ID:int,General3_Preset_ID:int,General1_Preset_Name:string,General2_Preset_Name:string,General3_Preset_Name:string,General1_Preset_Cost:int,General2_Preset_Cost:int,General3_Preset_Cost:int,Waypath_enabled:int,WaypathID:int,Speed:float");

//ScriptRegistrant<SCUD_Preset_Buy_Destroy_Object> SCUD_Preset_Buy_Destroy_Object_Registrant("SCUD_Preset_Buy_Destroy_Object","Unknown:float,Preset_Name:string,Cost:int,location:Vector3,Player_Type:int,Rotation:float,Explosion:string");
//ScriptRegistrant<SCUD_Preset_Buy_Send_Custom> SCUD_Preset_Buy_Send_Custom_Registrant("SCUD_Preset_Buy_Send_Custom","Unknown:float,Preset_Name:string,Cost:int,location:Vector3,Player_Type:int,Rotation:float,SendID:int,SendMessage:int,SendParam:int");
ScriptRegistrant<SCUD_Deployable_Vehicle> SCUD_Deployable_Vehicle_Registrant ("SCUD_Deployable_Vehicle","Animated_Preset:string,Explosion_Preset:string");
ScriptRegistrant<SCUD_Deploy_Animation> SCUD_Deploy_Animation_Registrant ("SCUD_Deploy_Animation","Time_Till_Death:float,Deployed_Tank_Preset:string,Explosion_Preset:string");
//ScriptRegistrant<SCUD_Generals_VehicleAbility> SCUD_Generals_VehicleAbility_Registrant("SCUD_Generals_VehicleAbility","Comment:string,General_Preset_ID:int,Health_Up_4_General:float,Shield_Up_4_General:float");
ScriptRegistrant<SCUD_DeathZoneOnCustom> SCUD_DeathZoneOnCustom_Registrant ("SCUD_DeathZoneOnCustom","Message:int,Explosion:string");

ScriptRegistrant<SCUD_Harvester_Control> SCUD_Harvester_Control_Registrant ("SCUD_Harvester_Control","USA_Harvester_Limit:int,China_Harvester_Limit:int,US_Harvester_Terminal_ID:int,CH_Harvester_Terminal_ID:int,USA_Harvester_Cost:int,China_Harvester_Cost:int");
ScriptRegistrant<SCUD_USHarvester> SCUD_USHarvester_Registrant ("SCUD_USHarvester","Harvester_Control_ID:int,Explosion_Preset_Name:string");
ScriptRegistrant<SCUD_CHHarvester> SCUD_CHHarvester_Registrant ("SCUD_CHHarvester","Harvester_Control_ID:int,Explosion_Preset_Name:string");
ScriptRegistrant<SCUD_USHarvester_Terminal> SCUD_USHarvester_Terminal_Registrant("SCUD_USHarvester_Terminal","Unknown:float,SendID:int,SendMessage:int,SendParam:int,Preset_Name:string,Cost:int,location:Vector3,Player_Type:int,Rotation:float,Waypath_enabled:int,WaypathID:int,Speed:float,Harvester_Control_ID:int");
ScriptRegistrant<SCUD_CHHarvester_Terminal> SCUD_CHHarvester_Terminal_Registrant("SCUD_CHHarvester_Terminal","Unknown:float,SendID:int,SendMessage:int,SendParam:int,Preset_Name:string,Cost:int,location:Vector3,Player_Type:int,Rotation:float,Waypath_enabled:int,WaypathID:int,Speed:float,Harvester_Control_ID:int");
//ScriptRegistrant<SCUD_CTO_Zone> SCUD_CTO_Zone_Registrant("SCUD_CTO_Zone","CTO_Controler_ID:int,US_Flag_Preset_ID:int,USLogo_Preset_Name:string,CH_Flag_Preset_ID:int,CHLogo_Preset_Name:string");
ScriptRegistrant<SCUD_Set_Player_Type_OnCustom> SCUD_Set_Player_Type_OnCustom_Registrant("SCUD_Set_Player_Type_OnCustom","Message:int,Player_Type:int");
ScriptRegistrant<SCUD_SuperWeapon> SCUD_SuperWeapon_Registrant ("SCUD_SuperWeapon","SuperWeaponAmmo:int,FireTimeSinceFirstShot:float");
ScriptRegistrant<SCUD_DozerBuildTurret> SCUD_DozerBuildTurret ("SCUD_DozerBuildTurret","Turret_PresetName:string,Cost:int,Controller_ID:int");
ScriptRegistrant<SCUD_TurretBuildup> SCUD_TurretBuildup ("SCUD_TurretBuildup","Buildup_Time:float,Turret_PresetName:string");
